#include "../noio/io.hh"
#include "list.hh"   

                                      // A CLASS:

class A
{
public:
   string s;
   A() {}
   A(string s)
   {
      this->s = s; 
   }
   friend bool operator == (const A& a1, const A& a2)
   {
      if (&a1 == null && &a2 == null) {
         return true;
      } else if (&a1 == null || &a2 == null) {
         return false;
      } else {
         return a1.s.equals(a2.s);
      }
   }
   friend bool operator != (const A& a1, const A& a2)
   {
      return !(a1 == a2);
   }
   /* SERIALISATION OUTPUT: */
   friend Writer& operator << (Writer& w,const A& a)
   {
      if (&a == null) {
         w << "null";
      } else {
         w << a.s;
      }
      return w;
   }
   /* SERIALISATION INPUT: */
   friend Reader& operator >> (Reader& r, A& a)
   {
      r >> a.s;
      return r;
   }
};

                                      // TEMPLATE INSTANTIATION:

template class Node<A>;
template class List<A>;
template class List_Extra<A>;
template class List_Io<A>;
template class List_Operator_Ee<A>;
template class List_X_Const_Xamp<A>;

const char* get_class_name(const List<A>*)
{
   return "List<A>";
}

                                      // MAIN FUNCTION!

int main()
{
   cout << "**** BEGIN t-list.exe!\n";

   List<A>* l = new List<A>();

   {
      cout << "*** BEGIN test 1\n";
      TELL(l->add_element(new A("apple")));
      TELL(OK(l));
      TELL(l->add_element(new A("banana")));
      TELL(OK(l));
      TELL(l->add_element(new A("carrot")));
      TELL(OK(l));
      TELL(l->add_element(new A("egg egg")));
      TELL(OK(l));
      TELL(l->get_last()->add_before_current(new A("dog-dog")));
      TELL(OK(l));
      ASSERT(*get_element_at_const(l,0)->get_data_const() == A("apple"));
      ASSERT(*get_element_at_const(l,1)->get_data_const() == A("banana"));
      ASSERT(*get_element_at_const(l,2)->get_data_const() == A("carrot"));
      ASSERT(*get_element_at_const(l,3)->get_data_const() == A("dog-dog"));
      ASSERT(*get_element_at_const(l,4)->get_data_const() == A("egg egg"));
      PRINT(*l);
      cout << "*** END   test 1\n";
   }
   {
      Writer* f;
      TELL(f = new File_Writer("t-list.el"));
      *f << *l;
      cout << "\n*** Written the following list to disk:\n";
      PRINT(*l);
      delete f;
   }
 
   {
      cout << "*** BEGIN test 2\n";
      TELL(set_element_at(l,2,new A("cally")));
      ASSERT(*get_element_at_const(l,0)->get_data_const() == A("apple"));
      ASSERT(*get_element_at_const(l,1)->get_data_const() == A("banana"));
      ASSERT(*get_element_at_const(l,2)->get_data_const() == A("cally"));
      ASSERT(*get_element_at_const(l,3)->get_data_const() == A("dog-dog"));
      ASSERT(*get_element_at_const(l,4)->get_data_const() == A("egg egg"));
      PRINT(*l);
      ASSERT(l->get_length() == 5);
      cout << "*** END   test 2\n";
   }

   {
      cout << "*** BEGIN test 3\n";
      TELL(OK(l));
      TELL(l->reverse());
      TELL(OK(l));
      PRINT(*l);
      ASSERT(l->get_length() == 5);
      ASSERT(*l->get_first_const()->get_data_const() == A("egg egg"));
      ASSERT(*get_element_at_const(l,0)->get_data_const() == A("egg egg"));
      ASSERT(*get_element_at_const(l,1)->get_data_const() == A("dog-dog"));
      ASSERT(*get_element_at_const(l,2)->get_data_const() == A("cally"));
      ASSERT(*get_element_at_const(l,3)->get_data_const() == A("banana"));
      ASSERT(*get_element_at_const(l,4)->get_data_const() == A("apple"));
      TELL(OK(l));
      cout << "*** END   test 3\n";
   }

   List<A>* l2;
   {
      cout << "*** BEGIN test 4\n";
      TELL(l2 = new List<A>());
      TELL(l2->add_element(l->get_first()));
      ASSERT(*get_element_at_const(l,0)->get_data_const() == A("egg egg"));
      ASSERT(*get_element_at_const(l,1)->get_data_const() == A("dog-dog"));
      ASSERT(*get_element_at_const(l,2)->get_data_const() == A("cally"));
      ASSERT(*get_element_at_const(l,3)->get_data_const() == A("banana"));
      ASSERT(*get_element_at_const(l,4)->get_data_const() == A("apple"));
      ASSERT(*get_element_at_const(l2,0)->get_data_const() == A("egg egg"));
      PRINT(*l2);
      TELL(OK(l));
      TELL(OK(l2));
      PRINT(*l);
      // ---------------------------------------------------
      // don't delete egg, because it is still on list l2.   
      //TELL(delete l->get_first()->get_data());
      // ---------------------------------------------------
      // removes egg from list l.
      TELL(delete l->get_first());
      ASSERT(l->get_length() == 4);
      ASSERT(*get_element_at_const(l,0)->get_data_const() == A("dog-dog"));
      ASSERT(*get_element_at_const(l,1)->get_data_const() == A("cally"));
      ASSERT(*get_element_at_const(l,2)->get_data_const() == A("banana"));
      ASSERT(*get_element_at_const(l,3)->get_data_const() == A("apple"));
      ASSERT(l2->get_length() == 1);
      ASSERT(*get_element_at_const(l2,0)->get_data_const() == A("egg egg"));
      TELL(OK(l));
      TELL(OK(l2));
      PRINT(*l2);
      PRINT(*l);
      cout << "*** END   test 4\n";
   }

   {
      cout << "*** BEGIN test 5\n";
      TELL(l->get_first()->add_after_current(l2->get_first()));
      ASSERT(*get_element_at_const(l,0)->get_data_const() == A("dog-dog"));
      ASSERT(*get_element_at_const(l,1)->get_data_const() == A("egg egg"));
      ASSERT(*get_element_at_const(l,2)->get_data_const() == A("cally"));
      ASSERT(*get_element_at_const(l,3)->get_data_const() == A("banana"));
      ASSERT(*get_element_at_const(l,4)->get_data_const() == A("apple"));
      TELL(OK(l));
      TELL(OK(l2));
      PRINT(*l2);
      PRINT(*l);
      cout << "*** END   test 5\n";
   }
   {
      cout << "*** BEGIN test 5\n";
      Reader* r;
      cout << "*** opened new File_Reader\n";
      TELL(r = new File_Reader("t-list.el")); 
      List<A>* l3 = new List<A>;
      TELL(*r >> *l3);
      PRINT(*l3);
      ASSERT(l3->get_length() == 6);
      ASSERT(*get_element_at_const(l3,0)->get_data_const() == A("apple"));
      ASSERT(*get_element_at_const(l3,1)->get_data_const() == A("banana"));
      ASSERT(*get_element_at_const(l3,2)->get_data_const() == A("carrot"));
      ASSERT(*get_element_at_const(l3,3)->get_data_const() == A("dog-dog"));
      ASSERT(*get_element_at_const(l3,4)->get_data_const() == A("egg"));
      ASSERT(*get_element_at_const(l3,5)->get_data_const() == A("egg"));
      TELL(OK(l3));
      TELL(delete r);
      cout << "*** END   test 5\n";
   }

   List<A>* l4;
   {
      cout << "*** BEGIN test 5\n";
      TELL(l4 = new List<A>);
      TELL(l4->add_element(new A("zero"))); 
      PRINT(*l4);
      TELL(l4->add_element(new A("one")));
      PRINT(*l4);
      TELL(l4->add_element(new A("two")));
      PRINT(*l4);
      ASSERT(*get_element_at_const(l4,0)->get_data_const() == A("zero"));
      ASSERT(*get_element_at_const(l4,1)->get_data_const() == A("one"));
      ASSERT(*get_element_at_const(l4,2)->get_data_const() == A("two"));
      TELL(OK(l4));
      cout << "*** END   test 5\n";
   }

   const List<A>* l4_const = l4;
   {
      cout << "*** BEGIN test 6\n";
      ASSERT(null != find_element_equal(l4->get_first(), A("one")));
      ASSERT(null != find_element_equal_const(l4_const->get_first_const(), A("one")));
      ASSERT(null == find_element_equal(l4->get_first(), A("can't find me")));
      ASSERT(null == find_element_equal_const(l4_const->get_first_const(), A("can't find me")));
      cout << "*** END   test 6\n";
   }
   const A* a;
   {
      cout << "*** BEGIN test 6\n";
      TELL(a = new A("NOTME!"));
      ASSERT(null == find_element_eq(l4->get_first(),a));
      ASSERT(null == find_element_eq_const(l4_const->get_first_const(),a));
      cout << "*** END   test 6\n";
   }

   {
      cout << "*** BEGIN test 7\n";
      TELL(l4->clear_dirty());
      ASSERT(*get_element_at_const(l4,0)->get_data_const() == A("zero"));
      ASSERT(*get_element_at_const(l4,1)->get_data_const() == A("one"));
      ASSERT(*get_element_at_const(l4,2)->get_data_const() == A("two"));
      int i=0;
      for_list_const (A,n,l4_const) {
         cout << "element[" << i << "] = " << *n << endl;
         i++; 
      }
      ASSERT(!l4->get_dirty()); 
      TELL(l4->add_element(new A("zigzag")));
      ASSERT(l4->get_dirty());
      cout << "*** END   test 7\n";
   }
   {
      cout << "*** BEGIN test 8\n";
      ASSERT(l4->get_length() == 4);
      ASSERT(*get_element_at_const(l4,0)->get_data_const() == A("zero"));
      ASSERT(*get_element_at_const(l4,1)->get_data_const() == A("one"));
      ASSERT(*get_element_at_const(l4,2)->get_data_const() == A("two"));
      ASSERT(*get_element_at_const(l4,3)->get_data_const() == A("zigzag"));
      TELL(set_element_at(l4,2,new A("twotwo")));
      ASSERT(*get_element_at_const(l4,0)->get_data_const() == A("zero"));
      ASSERT(*get_element_at_const(l4,1)->get_data_const() == A("one"));
      ASSERT(*get_element_at_const(l4,2)->get_data_const() == A("twotwo"));
      ASSERT(*get_element_at_const(l4,3)->get_data_const() == A("zigzag"));
      TELL(delete l4->get_last()->get_data());
      TELL(delete l4->get_last());
      ASSERT(l4->get_length() == 3);
      ASSERT(*get_element_at_const(l4,0)->get_data_const() == A("zero"));
      ASSERT(*get_element_at_const(l4,1)->get_data_const() == A("one"));
      ASSERT(*get_element_at_const(l4,2)->get_data_const() == A("twotwo"));
      cout << "*** END   test 8\n";
   }
   {
      cout << "*** BEGIN test 9\n";
      l4->clear_dirty();
      cout << "Here are the elements of the list:\n";
      for_list_const (A,n,l4_const) {
         PRINT(*n);
      }
      cout << "l4->get_dirty() should return 0 as the list is unmodified\n";
      ASSERT(!l4->get_dirty());
      TELL(l4->clear_dirty());
      ASSERT(false == l4->get_dirty());
      cout << "*** END   test 9\n";
   }
   List<A>* l5;
   {
      cout << "*** BEGIN test 10\n";
      TELL(l5 = new List<A>());
      TELL(l5->add_element(new A("1")));
      TELL(l5->add_element(new A("2")));
      TELL(l5->add_element(new A("3")));
      for_list_const (A,n,l4) {
         add_element_deep(l5,n->get_data_const());
      }
      ASSERT(*get_element_at_const(l5,0)->get_data_const() == A("1"));
      ASSERT(*get_element_at_const(l5,1)->get_data_const() == A("2"));
      ASSERT(*get_element_at_const(l5,2)->get_data_const() == A("3"));
      ASSERT(*get_element_at_const(l5,3)->get_data_const() == A("zero"));
      ASSERT(*get_element_at_const(l5,4)->get_data_const() == A("one"));
      ASSERT(*get_element_at_const(l5,5)->get_data_const() == A("twotwo"));
      ASSERT(false == l4->get_dirty());
      ASSERT(l5->get_dirty());
      cout << "*** END   test 10\n";
   }
   {
      cout << "*** BEGIN test 11\n";
      TELL(OK(l5));
      TELL(l5->reverse());
      TELL(OK(l5));
      ASSERT(*get_element_at_const(l5,5)->get_data_const() == A("1"));
      ASSERT(*get_element_at_const(l5,4)->get_data_const() == A("2"));
      ASSERT(*get_element_at_const(l5,3)->get_data_const() == A("3"));
      ASSERT(*get_element_at_const(l5,2)->get_data_const() == A("zero"));
      ASSERT(*get_element_at_const(l5,1)->get_data_const() == A("one"));
      ASSERT(*get_element_at_const(l5,0)->get_data_const() == A("twotwo"));
      TELL(l5->reverse());
      TELL(OK(l5));
      ASSERT(*get_element_at_const(l5,0)->get_data_const() == A("1"));
      ASSERT(*get_element_at_const(l5,1)->get_data_const() == A("2"));
      ASSERT(*get_element_at_const(l5,2)->get_data_const() == A("3"));
      ASSERT(*get_element_at_const(l5,3)->get_data_const() == A("zero"));
      ASSERT(*get_element_at_const(l5,4)->get_data_const() == A("one"));
      ASSERT(*get_element_at_const(l5,5)->get_data_const() == A("twotwo"));
      cout << "*** END   test 11\n";
   }

   Node<A>* found;
   {
      cout << "*** BEGIN test 12\n";
      ASSERT((found = find_element_equal(l5->get_first(), A("twotwo"))));
      ASSERT(5 == get_index(found));
      cout << "*** END   test 12\n";
   }

   {
      cout << "*** BEGIN test 13\n";
      l5->delete_deep();
      //PRINT(*l5);
      ASSERT(l5->get_length() == 0);
      delete l5;
      cout << "*** END   test 13\n";
   }
   {
      cout << "*** BEGIN test 14\n";
      List<A> list1;
      list1.add_element(new A("1"));
      list1.add_element(new A("2"));
      list1.add_element(new A("3"));
      List<A> list2;
      list2.add_element(new A("1"));
      list2.add_element(new A("2"));
      list2.add_element(new A("3"));
      ASSERT(lists_equal(&list1,&list2));
      cout << "*** END   test 14\n";
   }

   cout << "**** All tests succeeded!\n";
   cout << "**** END t-list.exe\n";
   return EXIT_SUCCESS;
}
END_OF_MAIN();
