#include "list.hh"

template class List_Io< string >;
template class List_Io< List<string> >;

const char* get_class_name(const List<string>*)
{
   return "List<string>";
}

const char* get_class_name(const List< List<string> >*)
{
   return "List< List<string> >";
}

List<string>* create_list(int list_no)
{
   List<string>* ls = new List<string>;
   ls->add_element(new string(quoted(string() + list_no + " apple")));
   ls->add_element(new string(quoted(string() + list_no + " banana")));
   ls->add_element(new string(quoted(string() + list_no + " carrot")));
   ls->add_element(new string(quoted(string() + list_no + " doughnut")));

   return ls;
}

int main()
{
   List<List<string> > lls;
   lls.add_element(create_list(0));
   lls.add_element(create_list(1));
   lls.add_element(create_list(2));

   PRINT(lls);

   return EXIT_SUCCESS;
}
END_OF_MAIN();
