#include <iostream>

class A
{
public:
   int data;
   static void* operator new(size_t s)
   {
      std::cout << "Inside A::operator new\n";
      return malloc(s);
   }
   static void operator delete(void* s)
   {
      std::cout << "Inside A::operator delete\n";
      free(s);
   }
   A()
   {
      std::cout << "Inside A constructor\n";
      data = 12;
   }
};

class B
{
public:   
   static void* operator new(size_t s)
   {
      std::cout << "Inside B::operator new\n";
      return malloc(s);
   }
   static void operator delete(void* s)
   {
      std::cout << "Inside B::operator delete\n";
      free(s);
   }
   B()
   {
      std::cout << "Inside B constructor\n";
   }
};

class C
{
public:   
   C()
   {
      std::cout << "Inside C constructor\n";
   }
};


int main()
{
   cout << "**** BEGIN t-list20-custom-new-delete.exe\n";

   {
      A a1;
      std::cout << a1.data << '\n';
      A* a2 = new A();
      std::cout << a2->data << '\n';
      delete a2;
   }

   {
      B b1;
      B* b2 = new B();
      delete b2;
   }
   cout << "**** END t-list20-custom-new-delete.exe\n";
}
