#include <iostream>

// singly linked list tester
#define null 0

class Node
{
public:
   int*  data;
   Node* next;
   Node(int* data)
   {
      this->data = data;
      this->next = null;
   }
};

class List
{
public:
   Node* head;
   List()
   {
      head = null;
   }
   void add_to_start(int* i)
   {
      Node* temp = new Node(i);
      temp->next = head;
      head = temp;
   }
};

void forward_traversal(List* list)
{
   std::cout << "forward_traversal list=";
   if (list == null) {
      std::cout << "null\n";
   } else {
      for (Node* n=list->head; n != null; n=n->next) {
         std::cout << *(n->data) << ' ';
      }
      std::cout << '\n';
   }
}

void backward_traversal_inner(Node* n)
{
   if (n == null) {
      // do nothing
   } else {
      backward_traversal_inner(n->next);
      std::cout << *(n->data) << ' ';
   }
}

void backward_traversal(List* list)
{
   std::cout << "backward_traversal list=";
   backward_traversal_inner(list->head);
   std::cout << '\n';
}



int main()
{
   cout << "**** BEGIN t-list18-sll.exe\n";

   List list;
   list.add_to_start(new int(4));
   list.add_to_start(new int(3));
   list.add_to_start(new int(2));
   list.add_to_start(new int(1));

   forward_traversal(&list);

   backward_traversal(&list);

   cout << "**** END t-list18-sll.exe\n";
   return EXIT_SUCCESS;
}
