#include "list.hh"

template class List_Extra<int>;
template class List_Io<int>;
template class List_Operator_Ee<int>;
template class List_Clone<int>;

const char* get_class_name(const List<int>*)
{
   return "List<int>";
}

int* clone(const int& i)
{
   return new int(i);
}

int main()
{
   cout << "**** BEGIN t-list15-clone.exe\n";

   List<int> list;
   list.add_element(new int(1));
   list.add_element(new int(2));
   int* pi = new int(3);
   list.add_element(pi);
   list.add_element(pi);
   list.add_element(new int(3));

   //cout << "Here is the list: " << list << endl;
   ASSERT(list.get_length() == 5);
   ASSERT(*get_element_at(&list, 0)->get_data_const() == int(1));
   ASSERT(*get_element_at(&list, 1)->get_data_const() == int(2));
   ASSERT(*get_element_at(&list, 2)->get_data_const() == int(3));
   ASSERT(*get_element_at(&list, 3)->get_data_const() == int(3));
   ASSERT(*get_element_at(&list, 4)->get_data_const() == int(3));

   List<int>* list2 = clone_shallow(&list);

   //PRINT(*list2);
   ASSERT(list2->get_length() == 5);
   ASSERT(*get_element_at(list2, 0)->get_data_const() == int(1));
   ASSERT(*get_element_at(list2, 1)->get_data_const() == int(2));
   ASSERT(*get_element_at(list2, 2)->get_data_const() == int(3));
   ASSERT(*get_element_at(list2, 3)->get_data_const() == int(3));
   ASSERT(*get_element_at(list2, 4)->get_data_const() == int(3));
   
   List<int>* list3 = clone_deep(&list);

   //PRINT(*list3);
   ASSERT(list3->get_length() == 5);
   ASSERT(*get_element_at(list3, 0)->get_data_const() == int(1));
   ASSERT(*get_element_at(list3, 1)->get_data_const() == int(2));
   ASSERT(*get_element_at(list3, 2)->get_data_const() == int(3));
   ASSERT(*get_element_at(list3, 3)->get_data_const() == int(3));
   ASSERT(*get_element_at(list3, 4)->get_data_const() == int(3));

   cout << "**** END t-list15-clone.exe\n";
   return EXIT_SUCCESS;
}
END_OF_MAIN();
