#include "list.hh"

//template class Node<A>;
//template class List<A>;
template class List_Extra<int>;
template class List_Io<int>;
template class List_Operator_Ee<int>;

const char* get_class_name(const List<int>*)
{
   return "List<int>";
}

int main()
{
   cout << "**** BEGIN t-list14-find.exe\n";

   List<int> list;
   list.add_element(new int(1));
   list.add_element(new int(2));
   int* pi = new int(3);
   list.add_element(pi);
   list.add_element(pi);
   list.add_element(new int(3));
   int* pi2 = null;
   list.add_element(pi2);

   cout << "Here is the list: " << list << endl;

   {
      cout << "Calling find_element_eq with pi:\n";
      for (Node<int>* find = list.get_first();
           (find = find_element_eq(find, pi)) != null;
           find = find->get_next()) {
         PRINT(*find);
         PRINT(get_index(find));
      }
   }

   {
      cout << "Calling find_element_eq with null:\n";
      int* pi3 = null;
      for (Node<int>* find = list.get_first();
           (find = find_element_eq(find, pi3)) != null;
           find = find->get_next()) {
         PRINT(*find);
         PRINT(get_index(find));
      }
   }

   {
      cout << "Calling find_element_equal with 3:\n";
      for (Node<int>* find = list.get_first();
           (find = find_element_equal(find, 3)) != null;
           find = find->get_next()) {
         PRINT(*find);
         PRINT(get_index(find));
      }
   }

   {
      cout << "Calling find_element_equal with null:\n";
      int* pi2 = null;
      for (Node<int>* find = list.get_first();
           (find = find_element_equal(find, *pi2)) != null;
           find = find->get_next()) {
         PRINT(*find);
         PRINT(get_index(find));
      }
   }

   {
      cout << "Here is the list:\n";
      PRINT(list);
      cout << "Removing all 3's from list:\n";
      Node<int>* n_next;
      for (Node<int>* find = list.get_first();
           (find = find_element_equal(find, 3)) != null;
           find = n_next) {
         n_next = find->get_next();
         PRINT(*find);
         delete find;
      }
      PRINT(list);
   }
   {
      cout << "Here is the list:\n";
      PRINT(list);
      cout << "Removing all null's from list:\n";
      int* null_pointer = null;
      Node<int>* n_next;
      for (Node<int>* find = list.get_first();
           (find = find_element_eq(find, null_pointer)) != null;
           find = n_next) {
         n_next = find->get_next();
         PRINT(*find);
         delete find;
      }
      PRINT(list);
   }

   PRINT(*get_element_at(&list, 1));

   // ERROR: out of bounds
   PRINT(*get_element_at(&list, 100));

   cout << "**** END t-list14-find.exe\n";
   return EXIT_SUCCESS;
}
END_OF_MAIN();
