#include "list.hh"

class B;

template class List_Io<B>;

class A
{
protected:   
   int a;
public:
   A()
   {
      a = 0;
   }
   A(int a)
   {
      this->a = a;
   }
   friend Reader& operator >> (Reader& r, A& a)
   {
      r >> a.a;
      return r;
   }
   friend Writer& operator << (Writer& w, const A& a)
   {
      w << a.a;
      return w;
   }
};

class B : public A
{
private:
   int b;
public:
   B()
   {
      b = 0;
   }
   B(int b) : A(b-1)
   {
      this->b = b;
   }
   friend Reader& operator >> (Reader& r, B& b)
   {
      r >> '(';
      r >> b.b;
      {
         A& a = b;
         r >> a;
      }
      r >> ')';
      return r;
   }
   friend Writer& operator << (Writer& w, const B& b)
   {
      w << '(' << b.b << ' ';
      const A& a = b;
      w << a << ')';
      return w;
   }
};

const char* get_class_name(const List<B>*)
{
   return "List<B>";
}

int main()
{
   cout << "**** BEGIN t-list13-inheritance.exe\n";

   {
      List<B> list;
      list.add_element(new B(1));
      list.add_element(new B(2));
      list.add_element(new B(3));
      PRINT(list);
      
      File_Writer f("t-list13.el");
      f << list;
   }
   {
      List<B> list;
      File_Reader r("t-list13.el");
      r >> list;
      PRINT(list);
   }

   cout << "**** END t-list13-inheritance.exe\n";
   return EXIT_SUCCESS;
}
END_OF_MAIN();
