#include "list.hh"

template class List_Extra<int>;
template class List_Io<int>;

const char* get_class_name(const List<int>*)
{
   return "List<int>";
}



ABSTRACT class Iterator_Base
{
public:   
   virtual bool iterator_has_more() = null;
   virtual void iterator_advance()  = null;
};

ABSTRACT class Const_Iterator : public Iterator_Base
{
public:   
   virtual const Node<int>* iterator_get_node_const() = null;
   virtual const int*       iterator_get_data_const() = null;
};

ABSTRACT class Mutable_Iterator : public Const_Iterator
{
public:   
   virtual Node<int>* iterator_get_node() = null;
   virtual int*       iterator_get_data() = null;
};

                                      // FORWARD_ITERATOR_CONST:

class Forward_Iterator_Const : public Const_Iterator
{
private:
   const Node<int>* current;
   const Node<int>* next;
public:   
   Forward_Iterator_Const(const List<int>* list)
   {
      current = null;
      next    = null;
      if (list != null) {
         current = list->get_first_const();
         if (current != null) {
            next = current->get_next_const();
         }
      }
   }
   bool has_more()
   {
      return current != null;
   }
   void advance()
   {
      current = next;
      if (next != null) {
         next = next->get_next_const();
      }
   }
   const Node<int>* get_node_const()
   {
      return current;
   }
   const int* get_data_const()
   {
      if (current != null) {
         return current->get_data_const();
      } else {
         return null;
      }
   }

                                         // OVERRIDING:
   
   // ITERATOR BASE:
   virtual bool iterator_has_more()
   {
      return has_more();
   }
   virtual void iterator_advance()
   {
      advance();
   }
   // CONST_ITERATOR:
   virtual const Node<int>* iterator_get_node_const()
   {
      return get_node_const();
   }
   virtual const int* iterator_get_data_const()
   {
      return get_data_const();
   }
};

                                      // FORWARD_ITERATOR:

class Forward_Iterator : public Mutable_Iterator
{
private:
   Node<int>* current;
   Node<int>* next;
public:   
   Forward_Iterator(List<int>* list)
   {
      current = null;
      next    = null;
      if (list != null) {
         current = list->get_first();
         if (current != null) {
            next = current->get_next();
         }
      }
   }
   bool has_more()
   {
      return current != null;
   }
   void advance()
   {
      current = next;
      if (next != null) {
         next = next->get_next();
      }
   }
   const Node<int>* get_node_const()
   {
      return current;
   }
   const int* get_data_const()
   {
      if (current != null) {
         return current->get_data();
      } else {
         return null;
      }
   }
   Node<int>* get_node()
   {
      return current;
   }
   int* get_data()
   {
      if (current != null) {
         return current->get_data();
      } else {
         return null;
      }
   }
                                      // OVERRIDING:

   // ITERATOR_BASE:
   virtual bool iterator_has_more()
   {
      return has_more();
   }
   virtual void iterator_advance()
   {
      advance();
   }
   // CONST_ITERATOR:
   virtual const Node<int>* iterator_get_node_const()
   {
      return get_node_const();
   }
   virtual const int* iterator_get_data_const()
   {
      return get_data_const();
   }
   // MUTABLE_ITERATOR:
   virtual Node<int>* iterator_get_node()
   {
      return get_node();
   }
   virtual int* iterator_get_data()
   {
      return get_data();
   }
};

                                      // BACKWARD_ITERATOR_CONST:

class Backward_Iterator_Const : public Const_Iterator
{
private:
   const Node<int>* current;
   const Node<int>* previous;
public:   
   Backward_Iterator_Const(const List<int>* list)
   {
      current  = null;
      previous = null;
      if (list != null) {
         current = list->get_last_const();
         if (current != null) {
            previous = current->get_previous_const();
         }
      }
   }
   bool has_more()
   {
      return current != null;
   }
   void advance()
   {
      current = previous;
      if (previous != null) {
         previous = previous->get_next_const();
      }
   }
   const Node<int>* get_node_const()
   {
      return current;
   }
   const int* get_data_const()
   {
      if (current != null) {
         return current->get_data_const();
      } else {
         return null;
      }
   }

                                         // OVERRIDING:
   
   // ITERATOR BASE:
   virtual bool iterator_has_more()
   {
      return has_more();
   }
   virtual void iterator_advance()
   {
      advance();
   }
   // CONST_ITERATOR:
   virtual const Node<int>* iterator_get_node_const()
   {
      return get_node_const();
   }
   virtual const int* iterator_get_data_const()
   {
      return get_data_const();
   }
};

                                      // BACKWARD_ITERATOR:

class Backward_Iterator : public Mutable_Iterator
{
private:
   Node<int>* current;
   Node<int>* previous;
public:   
   Backward_Iterator(List<int>* list)
   {
      current  = null;
      previous = null;
      if (list != null) {
         current = list->get_last();
         if (current != null) {
            previous = current->get_previous();
         }
      }
   }
   bool has_more()
   {
      return current != null;
   }
   void advance()
   {
      current = previous;
      if (previous != null) {
         previous = previous->get_previous();
      }
   }
   const Node<int>* get_node_const()
   {
      return current;
   }
   const int* get_data_const()
   {
      if (current != null) {
         return current->get_data();
      } else {
         return null;
      }
   }
   Node<int>* get_node()
   {
      return current;
   }
   int* get_data()
   {
      if (current != null) {
         return current->get_data();
      } else {
         return null;
      }
   }
                                      // OVERRIDING:

   // ITERATOR_BASE:
   virtual bool iterator_has_more()
   {
      return has_more();
   }
   virtual void iterator_advance()
   {
      advance();
   }
   // CONST_ITERATOR:
   virtual const Node<int>* iterator_get_node_const()
   {
      return get_node_const();
   }
   virtual const int* iterator_get_data_const()
   {
      return get_data_const();
   }
   // MUTABLE_ITERATOR:
   virtual Node<int>* iterator_get_node()
   {
      return get_node();
   }
   virtual int* iterator_get_data()
   {
      return get_data();
   }
};

                                      // ITERATE:

void iterate(Const_Iterator* i)
{
   for (; i->iterator_has_more(); i->iterator_advance()) {
      PRINT(*i->iterator_get_node_const());
   }
}

                                      // MAIN:

int main()
{
   cout << "**** BEGIN t-list11-iterator.exe\n";

   List<int> list;
   list.add_element(new int(1));
   list.add_element(new int(2));
   list.add_element(new int(3));

   PRINT(list);

   for (Backward_Iterator i(&list); i.has_more(); i.advance()) {
      PRINT(*i.get_node());
   }

   {
      Backward_Iterator bi(&list);
      iterate(&bi);
   }
   {
      Forward_Iterator bi(&list);
      iterate(&bi);
   }

   for (Forward_Iterator i(&list); i.has_more(); i.advance()) {
      PRINT(*i.get_data());
      i.get_node()->add_before_current(new int(-66));
      delete i.get_node();
//        if ((rand() % 2) == 0) {
//           i.add_after_current(new int(69));
//        }
   }

   PRINT(list);

   cout << "**** END t-list11-iterator.exe\n";
   return EXIT_SUCCESS;
}
END_OF_MAIN();
