#include "list.hh"   

                                      // TEMPLATE INSTANTIATION:

template class Node<string>;
template class List<string>;
template class List_Extra<string>;
template class List_Io<string>;
template class List_Operator_Ee<string>;
    
const char* get_class_name(const List<string>*)
{
   return "List<string>";
}

bool operator == (const string& s1, const string& s2)
{
   return s1.equals(s2);
}

                                      // MAIN FUNCTION!

// ostream& operator<<(ostream& o, const string& s)
// {
//    o << s.const_char_star();
//    return 0;
// }

int main()
{
   cout << "**** BEGIN t-list10.exe\n";

   {
      List<string>* list1 = new List<string>();
      TELL(list1->add_element(new string("apex")));
      TELL(list1->add_element(new string("banana")));
      TELL(list1->add_element(new string("carrot")));
      TELL(list1->add_element(new string("egg")));
      TELL(list1->get_last()->add_before_current(new string("dog")));
      //PRINT(*list1);

      ASSERT(list1->get_length() == 5);
      ASSERT(strings_equal(*get_element_at(list1, 0)->get_data_const(), "apex"));
      ASSERT(strings_equal(*get_element_at(list1, 1)->get_data_const(), "banana"));
      ASSERT(strings_equal(*get_element_at(list1, 2)->get_data_const(), "carrot"));
      ASSERT(strings_equal(*get_element_at(list1, 3)->get_data_const(), "dog"));
      ASSERT(strings_equal(*get_element_at(list1, 4)->get_data_const(), "egg"));

      //cout << "\nHere is list1:\n";
      //for_list_const (string, n , list1) {
      //   cout << *n->get_data_const() << endl;
      //}
   }

   {
      List<string> list2;
      list2.add_element(new string("anthrax"));
      list2.add_element(new string("boobies"));
      list2.add_element(new string("condiments"));

      //cout << "\nHere is list2:\n";
      //for_list_const (string, n , &list2) {
      //   cout << *n->get_data_const() << endl;
      //}

      ASSERT(list2.get_length() == 3);
      ASSERT(strings_equal(*get_element_at(&list2, 0)->get_data_const(), "anthrax"));
      ASSERT(strings_equal(*get_element_at(&list2, 1)->get_data_const(), "boobies"));
      ASSERT(strings_equal(*get_element_at(&list2, 2)->get_data_const(), "condiments"));
   }   
   
   cout << "**** END t-list10.exe\n";
   return EXIT_SUCCESS;
}
END_OF_MAIN();
