#include "list.hh"  

                                      // TEMPLATE INSTANTIATION:

template class Node<int>;
template class List<int>;
template class List_Extra<int>;
template class List_Operator_Ee<int>;
template class List_Io<int>;

const char* get_class_name(const List<int>*)
{
   return "List<int>";
}

                                      // MAIN FUNCTION:

int main() 
{
   cout << "**** BEGIN t-list09-add.exe\n";

   List<int>* list1;
   TELL(list1 = new List<int>());
   TELL(OK(list1));
   TELL(list1->add_element(new int(0)));
   TELL(OK(list1));
   TELL(list1->add_element(new int(1)));
   TELL(OK(list1));
   TELL(list1->add_element(new int(2)));
   TELL(OK(list1));
   TELL(list1->add_element(new int(3)));
   TELL(OK(list1));

   ASSERT(list1->get_length() == 4);
   ASSERT(*get_element_at(list1, 0)->get_data_const() == int( 0));
   ASSERT(*get_element_at(list1, 1)->get_data_const() == int( 1));
   ASSERT(*get_element_at(list1, 2)->get_data_const() == int( 2));
   ASSERT(*get_element_at(list1, 3)->get_data_const() == int( 3));

   TELL(list1->get_last()->add_after_current(new int(5)));
   TELL(OK(list1));
   TELL(list1->get_last()->add_before_current(new int(4)));
   TELL(OK(list1));
   TELL(list1->get_first()->add_before_current(new int(-2)));
   TELL(OK(list1));
   TELL(list1->get_first()->add_after_current(new int(-1)));
   TELL(OK(list1));
   //PRINT(*list1);
   ASSERT(list1->get_length() == 8);
   ASSERT(*get_element_at(list1, 0)->get_data_const() == int(-2));
   ASSERT(*get_element_at(list1, 1)->get_data_const() == int(-1));
   ASSERT(*get_element_at(list1, 2)->get_data_const() == int( 0));
   ASSERT(*get_element_at(list1, 3)->get_data_const() == int( 1));
   ASSERT(*get_element_at(list1, 4)->get_data_const() == int( 2));
   ASSERT(*get_element_at(list1, 5)->get_data_const() == int( 3));
   ASSERT(*get_element_at(list1, 6)->get_data_const() == int( 4));
   ASSERT(*get_element_at(list1, 7)->get_data_const() == int( 5));


   TELL(OK(list1));
   TELL(list1->delete_deep());
   TELL(OK(list1));

   //PRINT(*list1);
   ASSERT(list1->get_length() == 0);

   cout << "**** END t-list09-add.exe\n";
   return EXIT_SUCCESS;
}
END_OF_MAIN();
