#include "list.hh"  

                                      // TEMPLATE INSTANTIATION:

template class Node<int>;
template class List<int>;
template class List_Extra<int>;
template class List_Operator_Ee<int>;
template class List_Io<int>;

const char* get_class_name(const List<int>*)
{
   return "List<int>";
}

                                      // MAIN FUNCTION:

int main() 
{
   cout << "**** BEGIN t-list08-element-at.exe\n";

   List<int>* list1 = null;
   TELL(OK(list1));
   TELL(list1 = new List<int>());

   TELL(OK(list1));

   TELL(list1->add_element(new int(0)));
   TELL(list1->add_element(new int(1)));
   TELL(list1->add_element(new int(2)));
   TELL(list1->add_element(new int(3)));

   ASSERT(list1->get_length() == 4);
   ASSERT(*get_element_at(list1, 0)->get_data_const() == int(0));
   ASSERT(*get_element_at(list1, 1)->get_data_const() == int(1));
   ASSERT(*get_element_at(list1, 2)->get_data_const() == int(2));
   ASSERT(*get_element_at(list1, 3)->get_data_const() == int(3));
   //PRINT(*list1);

   //PRINT(*get_element_at(list1, 1));

   TELL(delete get_element_at(list1, 0)->get_data());
   TELL(set_element_at(list1, 0, new int(10)));

   //PRINT(*list1);
   ASSERT(list1->get_length() == 4);
   ASSERT(*get_element_at(list1, 0)->get_data_const() == int(10));
   ASSERT(*get_element_at(list1, 1)->get_data_const() == int(1));
   ASSERT(*get_element_at(list1, 2)->get_data_const() == int(2));
   ASSERT(*get_element_at(list1, 3)->get_data_const() == int(3));

   TELL(delete get_element_at(list1, 3)->get_data());
   TELL(set_element_at(list1, 3, new int(33)));

   //PRINT(*list1);
   ASSERT(list1->get_length() == 4);
   ASSERT(*get_element_at(list1, 0)->get_data_const() == int(10));
   ASSERT(*get_element_at(list1, 1)->get_data_const() == int(1));
   ASSERT(*get_element_at(list1, 2)->get_data_const() == int(2));
   ASSERT(*get_element_at(list1, 3)->get_data_const() == int(33));

   cout << "**** END t-list08-element-at.exe\n";
   return EXIT_SUCCESS;
}
END_OF_MAIN();
