#include "list.hh"  

class A
{
   int i;
public:
   A(int i) {
      this->i = i;
   }
   int get_i() const {
      return i;
   }
   friend bool operator == (const A& a1, const A& a2)
   {
      if ((&a1 == null) && (&a2 == null)) {
         return true;
      } else if ((&a1 == null) || (&a2 == null)) {
         return false;
      } else {
         return a1.i == a2.i;
      }
   }
};

                                      // TEMPLATE INSTANTIATION:

template class Node<A>;
template class List<A>;
template class List_Extra<A>;
template class List_Operator_Ee<A>;

void print_list(const List<A>* list)
{
   for_list_const (A, n, list) {
      cout << n->get_data_const()->get_i() << ' ';
   }
   cout << endl;
}


                                      // MAIN FUNCTION:

int main() 
{
   cout << "**** BEGIN t-list07-equals.exe\n";

   List<A>* list1;
   TELL(list1 = new List<A>());

   TELL(list1->add_element(new A(1)));
   TELL(list1->add_element(new A(2)));
   TELL(list1->add_element(new A(3)));
   TELL(list1->add_element(new A(4)));

   ASSERT(list1->get_length() == 4);
   ASSERT(*get_element_at(list1, 0)->get_data_const() == A(1));
   ASSERT(*get_element_at(list1, 1)->get_data_const() == A(2));
   ASSERT(*get_element_at(list1, 2)->get_data_const() == A(3));
   ASSERT(*get_element_at(list1, 3)->get_data_const() == A(4));

   List<A>* list2;
   TELL(list2 = new List<A>());

   ASSERT(!lists_equal(list1, list2));

   TELL(list2->add_element(new A(1)));
   TELL(list2->add_element(new A(2)));
   TELL(list2->add_element(new A(3)));
   TELL(list2->add_element(new A(4)));

   ASSERT(list2->get_length() == 4);
   ASSERT(*get_element_at(list2, 0)->get_data_const() == A(1));
   ASSERT(*get_element_at(list2, 1)->get_data_const() == A(2));
   ASSERT(*get_element_at(list2, 2)->get_data_const() == A(3));
   ASSERT(*get_element_at(list2, 3)->get_data_const() == A(4));

   ASSERT(lists_equal(list1, list2));

   ASSERT(*list1 == *list2);
   //PRINT(lists_equal(list1,list2));
   List<A>* null_list = null;
   ASSERT(!lists_equal(list1, null_list));

   A* a1 = null;
   A* a2 = null;
   ASSERT(List_Operator_Ee<A>::xs_equal(a1,a2));

   cout << "**** END t-list07-equals.exe\n";
   return EXIT_SUCCESS;
}
END_OF_MAIN();
