#include "list.hh"  

class A
{
   int i;
public:
   A(int i) {
      this->i = i;
   }
   int get_i() const {
      return i;
   }
   friend Writer& operator << (Writer& w, const A& a)
   {
      ASSERT(&a != null);
      w << a.i;
      return w;
   }
   friend bool operator == (const A& a1, const A& a2)
   {
      if ((&a1 == null) && (&a2 == null)) {
         return true;
      } else if ((&a1 == null) || (&a2 == null)) {
         return false;
      } else {
         return a1.i == a2.i;
      }
   }
};
                                      // TEMPLATE INSTANTIATION:

template class Node<A>;
template class List<A>;
template class List_Extra<A>;
template class List_Io<A>;

                                      // MAIN FUNCTION:

int main() 
{
   cout << "**** BEGIN t-list06-delete-duplicates-eq.exe\n";

   List<A>* list;
   TELL(list = new List<A>());

   TELL(list->add_element(new A(1)));
   TELL(list->add_element(new A(2)));
   A* a = new A(3);
   TELL(list->add_element(a));
   TELL(list->add_element(a));

   //cout << "Should print (1 2 3 3)\n";
   //PRINT(*list);

   ASSERT(list->get_length() == 4);
   ASSERT(*get_element_at(list, 0)->get_data_const() == A(1));
   ASSERT(*get_element_at(list, 1)->get_data_const() == A(2));
   ASSERT(*get_element_at(list, 2)->get_data_const() == A(3));
   ASSERT(*get_element_at(list, 3)->get_data_const() == A(3));

   TELL(delete_duplicates_eq(list));
   //cout << "Should print (1 2 3)\n";
   //PRINT(*list);

   ASSERT(list->get_length() == 3);
   ASSERT(*get_element_at(list, 0)->get_data_const() == A(1));
   ASSERT(*get_element_at(list, 1)->get_data_const() == A(2));
   ASSERT(*get_element_at(list, 2)->get_data_const() == A(3));

   cout << "**** END t-list06-delete-duplicates-eq.exe\n";
   return EXIT_SUCCESS;
}
END_OF_MAIN();
