#include "list.hh"  

                                      // TEMPLATE INSTANTIATION:

template class Node<int>;
template class List<int>;
template class List_Extra<int>;
template class List_Io<int>;
template class List_Operator_Ee<int>;

const char* get_class_name(const List<int>*)
{
   return "List<int>";
}

                                      // MAIN FUNCTION:

int main() 
{
   cout << "**** BEGIN t-list05-delete-duplicates-equal.exe\n";

   List<int>* list;
   TELL(list = new List<int>());

   TELL(list->add_element(new int(1)));
   TELL(list->add_element(new int(2)));
   TELL(list->add_element(new int(3)));
   TELL(list->add_element(new int(3)));

   int* i = new int(69);
   TELL(list->add_element(i));
   TELL(list->add_element(i));

   //cout << "Should print (1 2 3 3 69 69)\n";
   //PRINT(*list);
   ASSERT(list->get_length() == 6);
   ASSERT(*get_element_at(list, 0)->get_data_const() == int(1));
   ASSERT(*get_element_at(list, 1)->get_data_const() == int(2));
   ASSERT(*get_element_at(list, 2)->get_data_const() == int(3));
   ASSERT(*get_element_at(list, 3)->get_data_const() == int(3));
   ASSERT(*get_element_at(list, 4)->get_data_const() == int(69));
   ASSERT(*get_element_at(list, 5)->get_data_const() == int(69));

   TELL(OK(list));

   TELL(delete_duplicates_equal(list));

   TELL(OK(list));

   //PRINT(*list);
   ASSERT(list->get_length() == 4);
   ASSERT(*get_element_at(list, 0)->get_data_const() == int(1));
   ASSERT(*get_element_at(list, 1)->get_data_const() == int(2));
   ASSERT(*get_element_at(list, 2)->get_data_const() == int(3));
   ASSERT(*get_element_at(list, 3)->get_data_const() == int(69));

   ASSERT(null != find_element_equal(list->get_first(),69));
   ASSERT(null == find_element_equal(list->get_first(),63));

   {
      List<int>* list = null;
      PRINT(*list);
   }

   cout << "**** END t-list05-delete-duplicates-equal.exe\n";
   return EXIT_SUCCESS;
}
END_OF_MAIN();
