#include "list.hh"  

                                      // TEMPLATE INSTANTIATION:

template class Node<int>;
template class List<int>;
template class List_Extra<int>;
template class List_Io<int>;

const char* get_class_name(const List<int>*)
{
   return "List<int>";
}

                                      // MAIN FUNCTION:

int main() 
{
   cout << "**** BEGIN t-list04.exe\n";

   List<int>* list;
   TELL(list = new List<int>());

   TELL(list->add_element(new int(1)));
   TELL(list->add_element(new int(2)));
   TELL(list->add_element(new int(3)));
   TELL(list->add_element(new int(5)));
   TELL(list->get_last()->add_before_current(new int(4)));

   //cout << "Should print (1 2 3 4 5)\n";
   //PRINT(*list); 

   ASSERT(list->get_length() == 5);
   ASSERT(*get_element_at(list, 0)->get_data_const() == int(1));
   ASSERT(*get_element_at(list, 1)->get_data_const() == int(2));
   ASSERT(*get_element_at(list, 2)->get_data_const() == int(3));
   ASSERT(*get_element_at(list, 3)->get_data_const() == int(4));
   ASSERT(*get_element_at(list, 4)->get_data_const() == int(5));

   List<int>* list2;
   TELL(list2 = new List<int>());
   TELL(list2->add_element(new int(6)));
   TELL(list2->add_element(new int(7)));
   TELL(list2->add_element(new int(8)));

   TELL(list->add_list(list2));

   cout << "Should print out (1 2 3 4 5 6 7 8)\n"; 
   PRINT(*list);

   TELL(delete list->get_first()->get_data());
   TELL(delete list->get_first());

   OK(list);

   PRINT(*list);

   cout << "**** END t-list04.exe\n";
   return EXIT_SUCCESS;
}
END_OF_MAIN();
