#include "list.hh"

                                      // TEMPLATE INSTANTIATION:

template class Node<int>;
template class List<int>;
template class List_Extra<int>;
template class List_Io<int>;

const char* get_class_name(const List<int>*)
{
   return "List<int>";
}

                                      // MAIN FUNCTION:

int main() 
{
   cout << "**** BEGIN t-list-03.exe\n";

   List<int>* lst;
   TELL(lst = new List<int>());

   TELL(OK(lst));

   TELL(lst->add_element(new int(1)));
   TELL(lst->add_element(new int(2)));
   TELL(lst->add_element(new int(3)));
   TELL(lst->add_element(new int(5)));
   TELL(lst->get_last()->add_before_current(new int(4)));

   TELL(OK(lst));
   //cout << "Should print (1 2 3 4 5)\n";
   //PRINT(*lst); 
   ASSERT(lst->get_length() == 5);
   ASSERT(*get_element_at(lst, 0)->get_data_const() == int(1));
   ASSERT(*get_element_at(lst, 1)->get_data_const() == int(2));
   ASSERT(*get_element_at(lst, 2)->get_data_const() == int(3));
   ASSERT(*get_element_at(lst, 3)->get_data_const() == int(4));
   ASSERT(*get_element_at(lst, 4)->get_data_const() == int(5));

   TELL(OK(lst));
   TELL(lst->clear_dirty());

   for_list_const (int,i,lst) {
      PRINT(*i);
   }
   
   ASSERT(lst->get_dirty() == false);

   List<int>* lst2;
   TELL(lst2 = new List<int>());
   TELL(lst2->add_element(new int(6)));
   TELL(lst2->add_element(new int(7)));
   TELL(lst2->add_element(new int(8)));

   TELL(lst->add_list(lst2));

   //cout << "Should print out (1 2 3 4 5 6 7 8)\n"; 
   //PRINT(*lst);

   TELL(OK(lst));
   TELL(OK(lst2));

   ASSERT(lst->get_length() == 8);
   ASSERT(*get_element_at(lst, 0)->get_data_const() == int(1));
   ASSERT(*get_element_at(lst, 1)->get_data_const() == int(2));
   ASSERT(*get_element_at(lst, 2)->get_data_const() == int(3));
   ASSERT(*get_element_at(lst, 3)->get_data_const() == int(4));
   ASSERT(*get_element_at(lst, 4)->get_data_const() == int(5));
   ASSERT(*get_element_at(lst, 5)->get_data_const() == int(6));
   ASSERT(*get_element_at(lst, 6)->get_data_const() == int(7));
   ASSERT(*get_element_at(lst, 7)->get_data_const() == int(8));

   TELL(set_element_at(lst, 0, lst2->get_last()));
   
   ASSERT(lst->get_length() == 8);
   ASSERT(*get_element_at(lst, 0)->get_data_const() == int(8));
   ASSERT(*get_element_at(lst, 1)->get_data_const() == int(2));
   ASSERT(*get_element_at(lst, 2)->get_data_const() == int(3));
   ASSERT(*get_element_at(lst, 3)->get_data_const() == int(4));
   ASSERT(*get_element_at(lst, 4)->get_data_const() == int(5));
   ASSERT(*get_element_at(lst, 5)->get_data_const() == int(6));
   ASSERT(*get_element_at(lst, 6)->get_data_const() == int(7));
   ASSERT(*get_element_at(lst, 7)->get_data_const() == int(8));
   
   //PRINT(*lst);

   {
      List<int> lst3;
      lst3.add_element(new int(1));
      lst3.add_element(new int(2));
      lst3.add_element(new int(3));
      int* pi = null;
      lst3.add_element(pi);
      //PRINT(lst3);

      TELL(OK(&lst3));
      ASSERT(lst3.get_length() == 4);
      ASSERT(*get_element_at(&lst3, 0)->get_data_const() == int(1));
      ASSERT(*get_element_at(&lst3, 1)->get_data_const() == int(2));
      ASSERT(*get_element_at(&lst3, 2)->get_data_const() == int(3));
      ASSERT( get_element_at(&lst3, 3)->get_data_const() == null);
      TELL(OK(&lst3));
  }

   cout << "**** END t-lst-03.exe\n";
   return EXIT_SUCCESS;         
}
END_OF_MAIN();

