#include <stdio.h>
#include <iostream>
#include "../noio/io.hh"
#include "list.hh"


                                      // A CLASS:

class A
{
public:
   string s;
   A() {}
   A(string s)
   {
      this->s = s;
   }
   friend bool operator==(const A& a1, const A& a2)
   {
      return a1.s.equals(a2.s);
   }
   /* SERIALISATION OUTPUT: */
   friend ostream& operator<<(ostream& w, const A& a)
   {
      //w << "!";
      w << '(' << quoted(a.s) << ')';
      //w << "!";
      return w;
   }
   friend Writer& operator<<(Writer& w,const A& a)
   {
      w << '(' << quoted(a.s) << ')';
      return w;
   }
   /* SERIALISATION INPUT: */
   friend Reader& operator>>(Reader& r, A& a)
   {
      assert(r.looking_at('('));
      r.next_token();
      ASSERT(r.currently_string());
      ASSERT(a.s.equals(""));
      a.s = r.gulp_quoted_string();
      ASSERT(r.looking_at(')'));
      r.next_token();
      return r;
   }
};

                                      // TEMPLATE INSTANTIATION:

template class Node<A>;
template class List<A>;
template class List_Extra<A>;
template class List_Io<A>;
template class List_Ostream<A>;

                                      // MAIN FUNCTION:

int main()
{
   cout << "**** BEGIN t-list-02.exe!\n";

   {
      FILE* f;
      f = fopen("t-list.el", "rb");
      int ch;
      while ((ch = getc(f)) != EOF) {
         cout << (char)ch;
      }
      fclose(f);
      cout << endl;
   }

//     {
//        File_Reader* fr;
//        fr = new File_Reader("t-list.el");
//        //fr->debug_print();
//        //int ch;

//        for (;;) {
//           if (fr->currently_char()) {
//              PRINT(fr->peek_char());
//           } else if (fr->currently_identifier()) {
//              PRINT(fr->peek_identifier());
//           } else if (fr->currently_eof()) {
//              break;
//           }
//           fr->next_token();
//        }
//        delete fr;
//        cout << endl;
//     }

   {
      List<A>* list;
      list = new List<A>();

      Reader* fr = new Reader(new File_Gulper("t-list.el"));
      *fr >> *list;
      PRINT(*list);
   }

   cout << "**** END t-list-02.exe!\n";
}
