#include <iostream>
#define null 0

struct A
{
   int data;
   A(int data)
   {
      this->data = data;
   }

   friend bool operator==(const A& a1, const A& a2)
   {
      {
         const A* pa1 = &a1;
         const A* pa2 = &a2;
         if (pa1 == null && pa2 == null) {
            return true;
         } else if (pa1 == null || pa2 == null) {
            return false;
         }
      }
      return a1.data == a2.data;
   }
};


int main()
{
   {
      A a1(33);
      A a2(33);
      std::cout << (a1 == a2) << '\n';
   }
   {
      A a1(33);
      A* a2 = null;
      std::cout << (a1 == *a2) << '\n';
   }
};
