int main()
{
   List<int>* list1 = new List<int>();

   // prints out 0 (meaning list1 is not dirty)
   cout << list1->get_dirty() << endl;

   list1->add_element(new int(1));
   list1->add_element(new int(2));
   list1->add_element(new int(3));
   
   // prints out 1 (meaning list1 is dirty)
   cout << list1->get_dirty() << endl;

   // clears the "private_dirty" flag of list1
   list1->clear_dirty();

   // the following code prints out 1 2 3
   for_list_const (int,n,list1) {
      cout << *n << " ";   
   }
   cout << endl;
   
   // prints out 0 (meaning list1 is not dirty)
   cout << list1->get_dirty() << endl;
   
   // the following code prints out 3 2 1
   for_list_backwards_const (int,n,list1) {
      cout << *n << " ";   
   }
   cout << endl;
   
   // prints out 0 (meaning list1 is not dirty)
   cout << list1->get_dirty() << endl;
   
   List<int>* list2 = new List<int>();
   list2->add_element(new int(4));
   list2->add_element(new int(5));
   list2->add_element(new int(6));
   
   for_list_backwards (int,n,list1) {
      list2->add_to_start(n);
   }

   // prints out 1 (meaning list1 is dirty)
   cout << list1->get_dirty() << endl;

   // prints out 1 (meaning list2 is dirty)
   cout << list2->get_dirty() << endl;

   // clears the "private_dirty" flag of list2
   list2->clear_dirty();

   // prints out 1 2 3 4 5 6
   for_list_const (int,n,list2) {
      cout << *n << " ";   
   }
   cout << endl;

   // prints out 0 (meaning list2 is not dirty)
   cout << list2->get_dirty() << endl;

   // deletes all "private_data" fields in list2
   list2->delete_deep();
   // delete all nodes in list2
   delete list2;

   // list1->delete_deep() is not called since
   // all data objects on list1 are also on list2

   // deletes all nodes in list1
   delete list1;
}
